//------------------------------------------------------------------------------
// <autogenerated>
//     This code was generated by a tool.
//     Runtime Version: 1.0.3705.209
//
//     Changes to this file may cause incorrect behavior and will be lost if 
//     the code is regenerated.
// </autogenerated>
//------------------------------------------------------------------------------

// 
// This source code was auto-generated by wsdl, Version=1.0.3705.209.
// 
namespace com.swvoyages.reservation {
	using System;
	using System.ComponentModel;
	using System.Diagnostics;
	using System.Web.Services;
	using System.Web.Services.Protocols;
	using System.Xml.Serialization;
    
	///
	/// <summary>La classe <code>ReservationService</code> implmente 
	/// l'interface <code>IReservationService</code>. Son objectif 
	/// consiste  offrir un service d'accs au systme de rservation 
	/// de la socit SW-Voyages.</summary>
	///
	[WebServiceBindingAttribute(Name="ReservationService", 
		 Namespace="http://www.sw-tourisme-xml.org:8080/reservation_sw-tourisme-xml/services-type/ReservationService-interface")]
	[SoapIncludeAttribute(typeof(HotelAvailability))]
	[SoapIncludeAttribute(typeof(CarAvailability))]
	[SoapIncludeAttribute(typeof(AirAvailability))]
	public class ReservationService : WebService, IReservationService {
        
		///
		/// <value>Nom du service type de rservation arienne.</value>
		///
		private static String AIR_TMODEL_NAME = "sw-aviation-xml-org:reservation";

		///
		/// <summary>Nom du service type de rservation automobile.</summary>
		///
		private static String CAR_TMODEL_NAME = "sw-automobilisme-xml-org:reservation";

		///
		/// <summary>Nom du service type de rservation htelire.</summary>
		///
		private static String HOTEL_TMODEL_NAME = "sw-hotellerie-xml-org:reservation";

		///
		/// <summary>URL du registre UDDI de rfrence.</summary>
		///
		private static String UDDI_INQUIRE_URL = "http://www.sw-registre-uddi.org:8004/glue/inquire/uddi";

		///
		/// <summary>Le proxy-service de rservation arienne.</summary>
		///
		private static ReservationServiceAirProxy airProxy;
	
		///
		/// <summary>Le proxy-service de rservation automobile.</summary>
		///
		private static ReservationServiceCarProxy carProxy;
	
		///
		/// <summary>Le proxy-service de rservation htelire.</summary>
		///
		private static ReservationServiceHotelProxy hotelProxy;
	
		///
		/// <summary>Le gestionnaire de toutes les rservations locales
		/// en cours.</summary>
		///
		private static ReservationManager manager;

		///
		/// <summary>Le moteur de recherche des partenaires de rservation.
		/// </summary>
		/// 
		private static ReservationFinder finder;
	
		///
		/// <summary>Le constructeur du service de rservation. Rcupre, 
		/// via le registre UDDI, les URLs d'accs aux services de rservation 
		/// implments par les partenaires.</summary>
		///
		public ReservationService() {
			if (finder==null) {
				String[] parameters = this.Finder.lookup(UDDI_INQUIRE_URL, AIR_TMODEL_NAME);
				this.AirProxy.Url = parameters [1];
				parameters = this.Finder.lookup(UDDI_INQUIRE_URL, CAR_TMODEL_NAME);
				this.CarProxy.Url = parameters [1];
				parameters = this.Finder.lookup(UDDI_INQUIRE_URL, HOTEL_TMODEL_NAME);
				this.HotelProxy.Url = parameters [1];
			}
		}
			
		///
		/// <summary>Renvoie le moteur de recherche des partenaires
		/// de rservation.</summary>
		///
		/// <returns>le singleton du moteur de recherche des partenaires 
		/// de rservation.</returns>
		///
		private ReservationFinder Finder {
			get {
				lock(this) {
					if (finder==null) {
						finder = ReservationFinder.getUniqueInstance();
					}
					return finder;
				}
			}
		}

		///
		/// <summary>Renvoie le gestionnaire des rservations en 
		/// cours.</summary>
		///
		/// <returns>le singleton du gestionnaire des rservations en 
		/// cours</returns>
		///
		private ReservationManager Manager {
			get {
				lock(this) {
					if (manager==null) {
						manager = ReservationManager.getUniqueInstance();
					}
					return manager;
				}
			}
		}

		///
		/// <summary>Renvoie le proxy-service de rservation 
		/// arienne.</summary>
		///
		/// <returns>le singleton du proxy-service de rservation 
		/// arienne</returns>
		///
		private ReservationServiceAirProxy AirProxy {
			get {
				lock(this) {
					if (airProxy==null) {
						airProxy = new ReservationServiceAirProxy();
					}
					return airProxy;
				}
			}
		}

		///
		/// <summary>Renvoie le proxy-service de rservation 
		/// automobile.</summary>
		///
		/// <returns>le singleton du proxy-service de rservation 
		/// automobile</returns>
		///
		private ReservationServiceCarProxy CarProxy {
			get {
				lock(this) {
					if (carProxy==null) {
						carProxy = new ReservationServiceCarProxy();
					}
					return carProxy;
				}
			}
		}

		///
		/// <summary>Renvoie le proxy-service de rservation 
		/// htelire.</summary>
		///
		/// <returns>le singleton	du proxy-service de rservation 
		/// htelire</returns>
		///
		private ReservationServiceHotelProxy HotelProxy {
			get {
				lock(this) {
					if (hotelProxy==null) {
						hotelProxy = new ReservationServiceHotelProxy();
					}
					return hotelProxy;
				}
			}
		}

		///
		/// <summary>Annulation de la rservation dont l'identifiant
		/// est pass en paramtre.</summary>summary>
		///
		/// <param name="arg0">le n de la rservation  annuler</param>
		///
		/// <returns><code>true</code> si l'annulation s'est bien
		///	passe; <code>false</code> sinon</returns>
		///
		[WebMethodAttribute()]
		[SoapRpcMethodAttribute("urn:ReservationService/cancel", 
			 RequestNamespace="urn:ReservationService", ResponseNamespace="urn:ReservationService")]
		[return: SoapElementAttribute("return")]
		public bool cancel(int arg0) {

		    // Recherche de la rservation locale
			Reservation reservation = getReservation(arg0);
			Trace.WriteLine("reservation = " + reservation);
			Trace.Flush();

			// Connexion au service de rservation de SW-Air.
			int remoteId = reservation.RemoteAirReservationId;
			bool canceled = this.AirProxy.cancel(remoteId);

			// Connexion au service de rservation de SW-Voitures.
			remoteId = reservation.RemoteCarReservationId;
			if (remoteId!=0) {
				canceled = this.CarProxy.cancel(remoteId);
			}

			// Connexion au service de rservation de SW-Htels.
			remoteId = reservation.RemoteHotelReservationId;
			if (remoteId!=0) {
				canceled = this.HotelProxy.cancel(remoteId);
			}

			// Annulation de la rservation locale.
			this.Manager.removeReservation((Object)arg0);
			return true;
		}
       
		///
		/// <summary>Confirmation de la rservation dont l'identifiant
		/// est pass en paramtre.</summary>
		///
		/// <param name="arg0">le n de la rservation  confirmer
		/// </param>
		/// <param name="arg1">l'identifiant de la disponibilit
		///	arienne (vol aller) choisie</param>
		/// <param name="arg2">l'identifiant de la disponibilit
		///	arienne (vol retour) choisie</param>
		/// <param name="arg3">l'identifiant de la disponibilit
		///	htelire choisie</param>
		/// <param name="arg4">l'identifiant de la disponibilit
		///	automobile choisie</param>
		///
		/// <returns><code>true</code> si la confirmation s'est bien
		///	passe; <code>false</code> sinon</returns>
		///
		[WebMethodAttribute()]
		[SoapRpcMethodAttribute("urn:ReservationService/book", 
			 RequestNamespace="urn:ReservationService", ResponseNamespace="urn:ReservationService")]
		[return: SoapElementAttribute("return")]
		public bool book(int arg0, int arg1, int arg2, int arg3, int arg4) {

			// Recherche de la rservation locale
			Reservation reservation = getReservation(arg0);

			// Connexion au service de rservation de SW-Air.
			int remoteId = reservation.RemoteAirReservationId;
			int remoteDepartureAvailabilityId = reservation.getRemoteAirAvailabilityId(arg1);
			int remoteArrivalAvailabilityId = 0;
			if (reservation.RoundTrip) {
				remoteArrivalAvailabilityId = reservation.getRemoteAirAvailabilityId(arg2);
			}
			bool booked = this.AirProxy.book(remoteId, remoteDepartureAvailabilityId, remoteArrivalAvailabilityId);

			// Connexion au service de rservation de SW-Voitures.
			remoteId = reservation.RemoteCarReservationId;
			if (remoteId!=0) {
				int remoteAvailabilityId = reservation.getRemoteCarAvailabilityId(arg4);
				booked = this.CarProxy.book(remoteId, remoteAvailabilityId);
			}

			// Connexion au service de rservation de SW-Htels.
			remoteId = reservation.RemoteHotelReservationId;
			if (remoteId!=0) {
				int remoteAvailabilityId = reservation.getRemoteHotelAvailabilityId(arg3);
				booked = this.HotelProxy.book(remoteId, remoteAvailabilityId);
			}

			// Confirmation de la rservation locale (ici, la
			// rservation est supprime, mais dans un systme
			// plus proche de la ralit, elle serait transmise
			//  un logiciel de back-office de SW-Voyages).
			this.Manager.removeReservation((Object)arg0);
			return true;
		}
        
		///
		/// <summary>Renvoie les disponibilits de la centrale de rservation 
		/// arienne pour la rservation locale dont l'identifiant
		/// est pass en paramtre.</summary>
		///
		/// <param name="arg0">l'identifiant de la rservation
		///	locale</param>
		///
	 	/// <returns>les disponibilits de la centrale de rservation 
	 	/// arienne pour la rservation locale dont l'identifiant est 
	 	///	pass en paramtre</returns>
		///
		[WebMethodAttribute()]
		[SoapRpcMethodAttribute("urn:ReservationService/getAirAvailabilities", 
			 RequestNamespace="urn:ReservationService", ResponseNamespace="urn:ReservationService")]
		[return: SoapElementAttribute("return")]
		public AirAvailability[] getAirAvailabilities(int arg0) {

			// Recherche de la rservation locale
			Reservation reservation = getReservation(arg0);

			AirAvailability[] availabilities = reservation.AirAvailabilities;
			if (availabilities.Length!=0) {
				return availabilities;
			}

			// Connexion au service de rservation de SW-Air.
			availabilities = this.AirProxy.getAirAvailabilities(reservation.RemoteAirReservationId);

			reservation.AirAvailabilities=availabilities;
			return availabilities;
		}
        
		///
		/// <summary>Renvoie les disponibilits de la centrale de 
		/// rservation automobile pour la rservation locale dont 
		/// l'identifiant est pass en paramtre.</summary>
		///
		/// <param name="arg0">l'identifiant de la rservation
		///	locale</param>
		///
	 	/// <returns>les disponibilits de la centrale de rservation 
	 	/// automobile pour la rservation locale dont l'identifiant 
	 	/// est pass en paramtre.</returns>
		///
		[WebMethodAttribute()]
		[SoapRpcMethodAttribute("urn:ReservationService/getCarAvailabilities", 
			 RequestNamespace="urn:ReservationService", ResponseNamespace="urn:ReservationService")]
		[return: SoapElementAttribute("return")]
		public CarAvailability[] getCarAvailabilities(int arg0) {

			// Recherche de la rservation locale
			Reservation reservation = getReservation(arg0);

			CarAvailability[] availabilities = reservation.CarAvailabilities;
			if (availabilities.Length!=0) {
				return availabilities;
			}

			// Connexion au service de rservation de SW-Voitures.
			availabilities = this.CarProxy.getCarAvailabilities(reservation.RemoteCarReservationId);

			reservation.CarAvailabilities=availabilities;
			return availabilities;
		}
        
		///
		/// <summary>Renvoie les disponibilits de la centrale de 
		/// rservation htelire pour la rservation locale dont 
		/// l'identifiant est pass en paramtre.</summary>
		///
		/// <param name="arg0">l'identifiant de la rservation
		///	locale</param>
		///
	 	/// <returns>les disponibilits de la centrale de rservation 
	 	/// htelire pour la rservation locale dont l'identifiant 
	 	/// est pass en paramtre</returns>
		///
		[WebMethodAttribute()]
		[SoapRpcMethodAttribute("urn:ReservationService/getHotelAvailabilities", 
			 RequestNamespace="urn:ReservationService", ResponseNamespace="urn:ReservationService")]
		[return: SoapElementAttribute("return")]
		public HotelAvailability[] getHotelAvailabilities(int arg0) {

			// Recherche de la rservation locale
			Reservation reservation = getReservation(arg0);

			HotelAvailability[] availabilities = reservation.HotelAvailabilities;
			if (availabilities.Length!=0) {
				return availabilities;
			}

			// Connexion au service de rservation de SW-Htels.
			availabilities = this.HotelProxy.getHotelAvailabilities(reservation.RemoteHotelReservationId);

			reservation.HotelAvailabilities=availabilities;
			return availabilities;
		}
       
		///
		/// <summary>Recherche de disponibilits pour la rservation d'un
		/// voyage, en fonction des informations saisies par le client.</summary>
		///
		/// <param name="arg0">le nombre de passagers</param>
		/// <param name="arg1">la localit de dpart</param>
		/// <param name="arg2">la localit d'arrive</param>
		/// <param name="arg3">aller retour/aller simple</param>
		/// <param name="arg4">jour de dpart</param>
		/// <param name="arg5">mois de dpart</param> 
		/// <param name="arg6">anne de dpart</param>
		/// <param name="arg7">jour d'arrive</param>
		/// <param name="arg8">mois d'arrive</param> 
		/// <param name="arg9">anne d'arrive</param>
		/// <param name="arg10">rservation htelire demande</param>
		/// <param name="arg11">rservation automobile demande</param>
		///
	 	/// <returns>le n de rservation affect  la recherche de
	 	///	disponibilits du client</returns>
		///
		[WebMethodAttribute()]
		[SoapRpcMethodAttribute("urn:ReservationService/search", 
			 RequestNamespace="urn:ReservationService", ResponseNamespace="urn:ReservationService")]
		[return: SoapElementAttribute("return")]
		public int search(int arg0, String arg1, String arg2, bool arg3, int arg4, 
			int arg5, int arg6, int arg7, int arg8, int arg9, bool arg10, bool arg11) {

			// Cration d'une nouvelle rservation SW-Voyages.
			Reservation reservation = new Reservation();

			reservation.Passengers=arg0;
			reservation.From=arg1.Trim();
			reservation.To=arg2.Trim();
			reservation.RoundTrip=arg3;
			reservation.DepartureDay=arg4;
			reservation.DepartureMonth=arg5;
			reservation.DepartureYear=arg6;
			reservation.ArrivalDay=arg7;
			reservation.ArrivalMonth=arg8;
			reservation.ArrivalYear=arg9;

			// Connexion au service de rservation de SW-Air.
			int remoteAirReservationId = this.AirProxy.search(arg0, arg1, arg2, arg3, 
				arg4, arg5, arg6, arg7, arg8, arg9, reservation.Id);
			reservation.RemoteAirReservationId=remoteAirReservationId;

			// Connexion au service de rservation de SW-Voitures.
			if (arg11) {
				int remoteCarReservationId = this.CarProxy.search(arg0, arg1, arg2, arg3, 
					arg4, arg5, arg6, arg7, arg8, arg9, reservation.Id);
				reservation.RemoteCarReservationId=remoteCarReservationId;
			}

			// Connexion au service de rservation de SW-Htels.
			if (arg10) {
				int remoteHotelReservationId = this.HotelProxy.search(arg0, arg1, arg2, arg3, 
					arg4, arg5, arg6, arg7, arg8, arg9, reservation.Id);
				reservation.RemoteHotelReservationId=remoteHotelReservationId;
			}

			// Enregistrement de la nouvelle rservation dans le
			// registre local de SW-Voyages.
			int id = reservation.Id;
			this.Manager.newReservation((Object)id, (Object)reservation);
			return id;
		}

		///
		/// <summary>Renvoie la rservation locale dont l'identifiant
		/// est pass en paramtre.</summary>
		///
		/// <param name="reservationId">l'identifiant de la rservation 
		/// locale</param>
		///
		/// <returns>Reservation la rservation locale dont l'identifiant 
		/// est pass en paramtre.</returns>
		///
		private Reservation getReservation(int reservationId) {

			Reservation reservation = (Reservation)this.Manager.getReservation((Object)reservationId);
			if (reservation == null) { 
				throw new ArgumentException ("la rservation (id="+reservationId+") SW-Voyages n'est pas enregistre.");
			}
			return reservation;
		}
	}
}